package ch.frankel.blog.date;

import static java.util.Calendar.DAY_OF_MONTH;
import static java.util.Calendar.HOUR_OF_DAY;
import static java.util.Calendar.JUNE;
import static java.util.Calendar.MILLISECOND;
import static java.util.Calendar.MINUTE;
import static java.util.Calendar.MONTH;
import static java.util.Calendar.SECOND;
import static java.util.Calendar.YEAR;
import static org.testng.Assert.assertEquals;

import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang.time.DateUtils;
import org.joda.time.DateMidnight;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DateTest {

	private Date referenceDate;

	@SuppressWarnings("deprecation")
	@BeforeMethod
	protected void setUp() {

		referenceDate = new Date(112, 5, 3);
	}

	@Test
	public void calendarShouldBeEqualToDate() {

		Calendar calendar = Calendar.getInstance();

		calendar.set(YEAR, 2012);
		calendar.set(MONTH, JUNE);
		calendar.set(DAY_OF_MONTH, 3);
		calendar.set(HOUR_OF_DAY, 0);
		calendar.set(MINUTE, 0);
		calendar.set(SECOND, 0);
		calendar.set(MILLISECOND, 0);

		assertEquals(calendar.getTime(), referenceDate);
	}

	@Test
	public void truncatedCalendarShouldBeEqualToDate() {

		Calendar calendar = Calendar.getInstance();

		calendar.set(YEAR, 2012);
		calendar.set(MONTH, JUNE);
		calendar.set(DAY_OF_MONTH, 3);
		calendar = DateUtils.truncate(calendar, DAY_OF_MONTH);

		assertEquals(calendar.getTime(), referenceDate);
	}

	@Test
	public void dateWithCommonsLangShouldBeEqualToDate() {

		Date date = new Date();

		date = DateUtils.setYears(date, 2012);
		date = DateUtils.setMonths(date, JUNE);
		date = DateUtils.setDays(date, 3);
		date = DateUtils.truncate(date, DAY_OF_MONTH);

		assertEquals(date, this.referenceDate);
	}

	@Test
	public void dateMidnightShouldBeEqualToDate() {

		DateMidnight dm = new DateMidnight(2012, 6, 3);

		assertEquals(dm.toDate(), this.referenceDate);
	}
}
