package ch.frankel.blog.xml.catalogresolver;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlCatalogResolverTest {

	@Test(expectedExceptions = java.security.AccessControlException.class)
	public void shouldHaveNoNetworkAccess() throws IOException {

		HttpClient httpClient = new DefaultHttpClient();

		HttpGet httpGet = new HttpGet("http://www.google.com/");

		httpClient.execute(httpGet);
	}

	@DataProvider
	protected Object[][] getTestData() {

		Object[][] data = new Object[2][2];

		data[0][0] = "person.xml";
		data[0][1] = 2;
		data[1][0] = "order.xml";
		data[1][1] = 1;

		return data;
	}

	@Test(dataProvider = "getTestData", dependsOnMethods = "shouldHaveNoNetworkAccess")
	public void xmlShouldValidateAgainstLocalCachedSchema(String xml, Integer numberOfErrors)
			throws ParserConfigurationException, SAXException, IOException {

		SAXParserFactory factory = SAXParserFactory.newInstance();

		factory.setNamespaceAware(true);
		factory.setValidating(true);

		XMLReader reader = factory.newSAXParser().getXMLReader();

		reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage",
				"http://www.w3.org/2001/XMLSchema");

		reader.setEntityResolver(new CatalogResolver());

		InputStream stream = getClass().getClassLoader().getResourceAsStream(xml);

		ErrorHandler handler = mock(ErrorHandler.class);

		reader.setErrorHandler(handler);

		reader.parse(new InputSource(stream));

		verify(handler, times(numberOfErrors)).error(any(SAXParseException.class));
	}
}
