package ch.frankel.blog.java.good.model;

/**
 * Person entity.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 * @since 26 dc. 2010
 * @version 1.0
 */
public class Person {

	private Long id;

	private String name;

	public Long getId() {

		return id;
	}

	public void setId(Long id) {

		this.id = id;
	}

	public String getName() {

		return name;
	}

	public void setName(String name) {

		this.name = name;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		
		final int prime = 31;
		
		int result = 1;
		
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		
		return result;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		
		if (this == obj) {
			
			return true;
		}
		
		if (obj == null) {
			
			return false;
		}
		
		if (!(obj instanceof Person)) {
			
			return false;
		}
		
		Person other = (Person) obj;
		
		if (id == null) {
			
			if (other.id != null) {
				
				return false;
			}
			
		} else if (!id.equals(other.id)) {
			
			return false;
		}
		
		return true;
	}
}
