package ch.frankel.blog.tomcat.valve;

import java.io.IOException;

import javax.servlet.ServletException;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

/**
 * An example valve to log processing time for a request.
 * 
 * @author Nicolas Frankel
 */
public class PerformanceValve extends ValveBase {

	/**
	 * @see org.apache.catalina.valves.ValveBase#invoke(org.apache.catalina.connector.Request,
	 *      org.apache.catalina.connector.Response)
	 */
	public void invoke(Request request, Response response) throws IOException,
			ServletException {

		// Starting time
		long start = System.currentTimeMillis();

		// Invoke next valve or true processing
		getNext().invoke(request, response);

		// Compute processing time
		long time = System.currentTimeMillis() - start;

		if (containerLog.isInfoEnabled()) {

			containerLog.info("Request took " + time + " ms ("
					+ request.getDecodedRequestURI() + ")");
		}
	}

	
	/**
	 * @see org.apache.catalina.valves.ValveBase#getInfo()
	 */
	public String getInfo() {

		return getClass() + "/1.0";
	}
}
