package ch.frankel.blog.tomcat.valve;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

/**
 * An example valve that sets a configurable dummy cookie.
 * 
 * @author Nicolas Frankel
 */
public class CookieValve extends ValveBase {

	/** Cookie name. */
	private String name;
	
	/** Cookie value. */
	private String value;
	
	/**
	 * @see org.apache.catalina.valves.ValveBase#invoke(org.apache.catalina.connector.Request, org.apache.catalina.connector.Response)
	 */
	public void invoke(Request request, Response response) throws IOException,
			ServletException {
		
		Cookie cookie = new Cookie(name, value);
		
		response.addCookie(cookie);

		getNext().invoke(request, response);
	}

	public void setName(String name) {

		this.name = name;
	}

	public void setValue(String value) {

		this.value = value;
	}
}
