<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<!DOCTYPE html>
<html>
<head>
<c:url value="/style/style.css" var="styleCss" scope="page" />
<link rel="stylesheet" type="text/css" href="${styleCss}" />
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<title>Welcome to Envers Spring Security/Data integration</title>
</head>
<body>
	<section id="menu">
		<c:url value="/j_spring_security_logout" var="logoutUrl" scope="page" />
		<form action="${pageScope.logoutUrl}">
			<input type="submit" value="Logout" />
		</form>
	</section>
	<c:if test="${not empty requestScope.stuff}">
		<section>New stuff ${requestScope.stuff.id} created!</section>
	</c:if>
	<section>
		<c:url var="submitUrl" value="/stuff/new" scope="page" />
		<form:form action="${pageScope.submitUrl}">
			<input type="submit" value="Create new stuff" />
		</form:form>
	</section>
	<section>
		<table>
			<thead>
				<tr>
					<th>Id</th>
					<th>Revision</th>
					<th>Timestamp</th>
					<th>User</th>
				</tr>
			</thead>
			<tbody>
				<c:forEach items="${requestScope.revisionedStuffs}" var="revisionedStuff">
					<tr>
						<td>${revisionedStuff.key}</td>
						<c:forEach items="${revisionedStuff.value}" var="auditedRevision"> 
							<td>${auditedRevision.id}</td>
							<td>${auditedRevision.timestamp}</td>
							<td>${auditedRevision.user}</td>
						</c:forEach>
					</tr>
				</c:forEach>
			</tbody>
		</table>
	</section>
</body>
</html>