package ch.frankel.blog.essd.controller;

import static org.springframework.web.bind.annotation.RequestMethod.GET;
import static org.springframework.web.bind.annotation.RequestMethod.POST;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import ch.frankel.blog.essd.persistence.entity.Stuff;
import ch.frankel.blog.essd.persistence.envers.AuditedRevisionEntity;
import ch.frankel.blog.essd.service.StuffService;

@Controller
public class StuffController {

	@Autowired
	private StuffService stuffService;

	@RequestMapping(method = GET)
	public String viewStuffPage(Model model) {

		setStuffHistory(model);

		return "stuff";
	}

	@RequestMapping(value = "/new", method = POST)
	public String createStuffPage(Model model) {

		Stuff stuff = stuffService.createNewStuff();

		model.addAttribute(stuff);

		setStuffHistory(model);

		return "stuff";
	}

	private void setStuffHistory(Model model) {

		Map<Long, List<AuditedRevisionEntity>> revisionedStuffs = stuffService.getAllRevisionedStuffs();

		model.addAttribute("revisionedStuffs", revisionedStuffs);
	}
}
