package ch.frankel.blog.essd.service.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.springframework.data.history.Revision;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.history.Revisions;
import org.springframework.util.ReflectionUtils;

import ch.frankel.blog.essd.persistence.entity.Stuff;
import ch.frankel.blog.essd.persistence.envers.AuditedRevisionEntity;
import ch.frankel.blog.essd.persistence.repository.StuffRepository;
import ch.frankel.blog.essd.service.StuffService;

public class StuffServiceImpl implements StuffService {

	private StuffRepository stuffRepository;

	@Override
	public Stuff createNewStuff() {

		return stuffRepository.save(new Stuff());
	}

	@Override
	public Map<Long, List<AuditedRevisionEntity>> getAllRevisionedStuffs() {

		List<Stuff> stuffs = stuffRepository.findAll();

		Map<Long, List<AuditedRevisionEntity>> revisionedStuffs = new TreeMap<Long, List<AuditedRevisionEntity>>();

		for (Stuff stuff : stuffs) {

			Revisions<Integer, Stuff> revisions = stuffRepository.findRevisions(stuff.getId());

			List<AuditedRevisionEntity> auditedRevisionEntities = new ArrayList<AuditedRevisionEntity>();

			for (Revision<Integer, Stuff> revision : revisions.getContent()) {

				Field field = ReflectionUtils.findField(Revision.class, "metadata");

				ReflectionUtils.makeAccessible(field);

				@SuppressWarnings("rawtypes")
				RevisionMetadata metadata = (RevisionMetadata) ReflectionUtils.getField(field, revision);

				AuditedRevisionEntity auditedRevisionEntity = (AuditedRevisionEntity) metadata.getDelegate();

				auditedRevisionEntities.add(auditedRevisionEntity);
			}

			revisionedStuffs.put(((Stuff) revisions.getLatestRevision().getEntity()).getId(), auditedRevisionEntities);
		}
		
		return revisionedStuffs;
	}

	@Override
	public Stuff updateStuff(Stuff stuff) {

		return stuffRepository.save(stuff);
	}

	public void setStuffRepository(StuffRepository stuffRepository) {

		this.stuffRepository = stuffRepository;
	}
}
