package ch.frankel.blog.spring.beans.overwriting;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertTrue;

import javax.swing.JButton;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

@ContextConfiguration("classpath:spring-primary.xml")
public class BeanOverridingTest extends AbstractTestNGSpringContextTests {

	@Test
	public void beanSixValueShouldBeReadFromDuplicatePropertyFile() {

		SayHelloBean bean = (SayHelloBean) applicationContext.getBean("six");

		assertEquals(bean.getValue(), "Sixth");
	}

	@Test
	public void beanSevenClassShouldReadFromDuplicatePropertyFile() {

		Object bean = applicationContext.getBean("seven");

		assertTrue(bean instanceof JButton);
	}
}
