package ch.frankel.blog.spring.beans.overwriting;

import static com.google.common.collect.Iterables.filter;
import static com.google.common.collect.Iterables.size;
import static java.util.Arrays.asList;
import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertSame;

import java.util.List;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

import com.google.common.base.Predicate;

@ContextConfiguration(locations = { "classpath:spring-primary.xml" })
public class BeanBaseAssertsTest extends AbstractTestNGSpringContextTests {

	private static final String BEAN_NAME = "one";

	@Test
	public void defaultBeanOneShouldScopedSingleton() {
		
		Object bean1 = applicationContext.getBean(BEAN_NAME);
		Object bean2 = applicationContext.getBean(BEAN_NAME);
		
		assertSame(bean1, bean2);
	}
	
	@Test
	public void thereShouldBeNineDeclaredBeansInBaseContext() {

		List<String> beanDefinitionNames = asList(applicationContext.getBeanDefinitionNames());

		/* Real beans are beans which name don't start with "org.springframework.context.annotation.". */
		int realSize = size(filter(beanDefinitionNames, new DeclaredBeanPredicate()));
		
		assertEquals(realSize, 9);
	}

	private class DeclaredBeanPredicate implements Predicate<String> {

		@Override
		public boolean apply(String beanName) {

			return !beanName.startsWith("org.springframework.context.annotation.");
		}
	}
}
