package ch.frankel.blog.spring.beans.overwriting;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotSame;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

@ContextConfiguration({ "classpath:spring-primary.xml", "classpath:spring-senary.xml" })
public class BeanOverwriting6Test extends AbstractTestNGSpringContextTests {

	private static final String EXPECTED_BEAN_VALUE = "Overwriting";
	private static final String BEAN_NAME = "five";

	@Test
	public void beanFiveScopeShouldBeReadFromOverwritingBean() {

		SayHelloBean bean1 = (SayHelloBean) applicationContext.getBean(BEAN_NAME);
		SayHelloBean bean2 = (SayHelloBean) applicationContext.getBean(BEAN_NAME);

		assertEquals(bean1.getValue(), EXPECTED_BEAN_VALUE);
		assertEquals(bean2.getValue(), EXPECTED_BEAN_VALUE);
		assertNotSame(bean1, bean2);
	}
}
