package ch.frankel.blog.spring.beans.overwriting;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotEquals;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.Test;

import ch.frankel.blog.spring.beans.overwriting.SayHelloBean;

@ContextConfiguration({ "classpath:spring-secondary.xml", "classpath:spring-primary.xml" })
public class BeanOverwriting2Test extends AbstractTestNGSpringContextTests {

	@Test
	public void beanOneValueShouldBeReadFromBaseBean() {

		SayHelloBean bean = (SayHelloBean) applicationContext.getBean("one");

		assertNotEquals(bean.getValue(), "Overwriting");
		assertEquals(bean.getValue(), "One");
	}
}
