package ch.frankel.blog.spring.sweet.web.controller;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.model;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.view;
import static org.springframework.test.web.servlet.setup.MockMvcBuilders.webAppContextSetup;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.web.context.WebApplicationContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import ch.frankel.blog.spring.sweet.config.JavaConfig;
import ch.frankel.blog.spring.sweet.config.WebConfig;

@WebAppConfiguration
@ContextConfiguration(classes = { JavaConfig.class, WebConfig.class })
public class SayHelloControllerIT extends AbstractTestNGSpringContextTests {

	private MockMvc mockMvc;

	@BeforeMethod
	public void setUp() {

		mockMvc = webAppContextSetup((WebApplicationContext) applicationContext).build();
	}

	@DataProvider
	protected Object[][] pathParameterAndExpectedModelValue() {

		String[] world = new String[] { "/sayhello/World", "Hello World" };
		String[] jo = new String[] { "/sayhello/Jo", "Hello Jo" };
		String[] jack = new String[] { "/sayhello/Jack", "Hello Jack" };
		String[] william = new String[] { "/sayhello/William", "Hello William" };
		String[] averell = new String[] { "/sayhello/Averell", "Hello Averell" };

		return new Object[][] { world, jo, jack, william, averell };
	}

	@Test(dataProvider = "pathParameterAndExpectedModelValue")
	public void accessingSayhelloWithPathShouldForwardToSayHelloJspWithModelFilled(String path,
			String value) throws Exception {

		mockMvc.perform(get(path)).andExpect(view().name("sayHello"))
				.andExpect(model().attribute("name", value));
	}
}
