package ch.frankel.blog.spring.sweet.web.controller;

import static org.springframework.web.bind.annotation.RequestMethod.GET;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import ch.frankel.blog.spring.sweet.web.service.HelloService;

@Controller
public class SayHelloController {

	private final HelloService helloService;

	public SayHelloController(HelloService helloService) {

		this.helloService = helloService;
	}

	@RequestMapping(value = "/sayhello/{name}", method = GET)
	public String sayHello(@PathVariable("name") String name, Model model) {

		String hello = helloService.getHello();

		model.addAttribute("name", hello + " " + name);

		return "sayHello";
	}
}
