package ch.frankel.blog.spring.sweet.config;

import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

import ch.frankel.blog.spring.sweet.web.controller.SayHelloController;
import ch.frankel.blog.spring.sweet.web.service.HelloService;

@Configuration
@EnableWebMvc
public class WebConfig extends WebMvcConfigurerAdapter {

	@Bean
	public SayHelloController sayHelloController(HelloService helloService) {
		
		return new SayHelloController(helloService);
	}
	
	@Bean
    public ViewResolver jspViewResolver() {
 
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();

        viewResolver.setPrefix("/WEB-INF/page/");
        viewResolver.setSuffix(".jsp");

        return viewResolver;
    }
	
	@Bean
    public MessageSource messageSource() {
 
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();

        messageSource.setBasenames("classpath:message");
        messageSource.setUseCodeAsDefaultMessage(true);
        messageSource.setDefaultEncoding("UTF-8");

        return messageSource;
    }
}
