package ch.frankel.blog.springdata.solr.repository;

import ch.frankel.blog.springdata.solr.entity.Loan;
import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.repository.Facet;
import org.springframework.data.solr.repository.Query;
import org.springframework.data.solr.repository.SolrRepository;

import java.util.List;

public interface LoanRepository extends SolrRepository<Loan, String> {

    List<Loan> findByLoanType(String loan);

    List<Loan> findByTitleContaining(String title);

    @Query("state_name:[* TO *]")
    List<Loan> findLocalized();

    @Query("*:*")
    @Facet(fields = "loan_type")
    FacetPage<Loan> findAllLoanTypes(Pageable page);
}
