package ch.frankel.blog.springdata.solr.repository;

import ch.frankel.blog.springdata.solr.config.JavaConfig;
import ch.frankel.blog.springdata.solr.entity.Loan;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.solr.core.query.result.FacetFieldEntry;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.support.AnnotationConfigContextLoader;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.List;

import static org.testng.Assert.*;

@ContextConfiguration(classes = JavaConfig.class, loader = AnnotationConfigContextLoader.class)
public class LoanRepositoryTest extends AbstractTestNGSpringContextTests {

    private LoanRepository repository;

    @BeforeMethod
    protected void setUp() {

        repository = applicationContext.getBean(LoanRepository.class);
    }

    @Test
    public void count_should_return_correct_count() {

        assertEquals(repository.count(), 39);
    }

    @Test
    public void find_by_exact_loantype_loan_should_return_relevant_loans() {

        List<Loan> loans = repository.findByLoanType("Loan");

        assertNotNull(loans);
        assertFalse(loans.isEmpty());
        assertEquals(loans.size(), 30);
    }

    @Test
    public void find_by_title_containing_Program_should_return_relevant_loans() {

        List<Loan> loans = repository.findByTitleContaining("Program");

        assertNotNull(loans);
        assertFalse(loans.isEmpty());
        assertEquals(loans.size(), 18);
    }

    @Test
    public void find_localized_should_return_single_relevant_loan() {

        List<Loan> loans = repository.findLocalized();

        assertNotNull(loans);
        assertFalse(loans.isEmpty());
        assertEquals(loans.size(), 1);

        Loan loan = loans.iterator().next();

        assertEquals(loan.getState(), "Alabama");
        assertEquals(loan.getTitle(), "Community Express");
    }

    @Test
    public void find_all_available_existing_types() {

        FacetPage<Loan> facet = repository.findAllLoanTypes(new PageRequest(1, 10));

        Page<FacetFieldEntry> page = facet.getFacetResultPage("loan_type");

        assertEquals(page.getNumberOfElements(), 3);
    }
}
