package ch.frankel.blog.springdata.solr.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.repository.config.EnableSolrRepositories;
import org.springframework.data.solr.server.support.HttpSolrServerFactoryBean;

@Configuration
@EnableSolrRepositories("ch.frankel.blog.springdata.solr.repository")
public class JavaConfig {

    @Bean
    protected HttpSolrServerFactoryBean solrServerFactory() {

        HttpSolrServerFactoryBean factory = new HttpSolrServerFactoryBean();

        factory.setUrl("http://localhost:8983/solr");

        return factory;
    }

    @Bean
    public SolrOperations solrTemplate() throws Exception {

        return new SolrTemplate(solrServerFactory().getObject());
    }
}
