package ch.frankel.blog.security.sessionfixation;

import org.springframework.core.annotation.Order;
import org.springframework.security.web.context.AbstractSecurityWebApplicationInitializer;

import static org.springframework.core.Ordered.HIGHEST_PRECEDENCE;
import static org.springframework.web.servlet.support.AbstractDispatcherServletInitializer.DEFAULT_SERVLET_NAME;

@Order(HIGHEST_PRECEDENCE)
public class MySecurityWebAppInitializer extends AbstractSecurityWebApplicationInitializer {

    @Override
    protected String getDispatcherWebApplicationContextSuffix() {
        return DEFAULT_SERVLET_NAME;
    }
}
