package ch.frankel.blog.security.sessionfixation;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.Mapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;

@Controller
public class SampleController {

    @RequestMapping("/hello")
    @ResponseBody
    public String sayHello(HttpServletResponse response) {
        setHtmlContentType(response);
        return "<html><body>hello";
    }

    @RequestMapping("/")
    @ResponseBody
    public String home(HttpServletResponse response) {
        setHtmlContentType(response);
        return "<html><body><a href='hello'>hello</a>";
    }

    private void setHtmlContentType(HttpServletResponse response) {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
    }
}
