package ch.frankel.blog.vaadin.scala

import com.vaadin.event.EventRouter
import com.vaadin.ui.{Button, CustomComponent, HorizontalLayout, TextField}


@SerialVersionUID(1L)
class CompositeFieldButton extends CustomComponent with Router {

	val field = new TextField(null, "world!")
	
	val layout = new HorizontalLayout()

	addListener(classOf[Button#ClickEvent], "displayMessage")
	
	setCompositionRoot(layout)
	
	layout.addComponent(field)
	
	val button = new Button("Hello") {

		addListener(new SimpleRouterClickListener(eventRouter))
	}
	
	layout.addComponent(button)
	
	def displayMessage(event:Button#ClickEvent) = {
		
		getWindow().showNotification(button.getCaption() + " " + field.getValue().asInstanceOf[String])
	}
}