<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html lang="en">
<head>
<title>Welcome to More Vaadin</title>
<link rel="stylesheet" type="text/css" href="css/bootstrap.css" />
</head>
<body>
	<div class="navbar navbar-fixed-top">
		<div class="navbar-inner">
			<div class="container">
				<a class="brand" href="#">More Vaadin</a>
				<ul class="nav">
					<li <c:if test="${requestScope.requested_uri == '/welcome'}"> class="active"</c:if>><a href="welcome"><i class="icon-home icon-white"></i> Welcome</a></li>
					<li <c:if test="${requestScope.requested_uri == '/learning'}"> class="active"</c:if>><a href="learning"><i class="icon-book icon-white"></i> Learning Vaadin</a></li>
					<li <c:if test="${requestScope.requested_uri == '/articles'}"> class="active"</c:if>><a href="articles"><i class="icon-pencil icon-white"></i> Articles</a></li>
					<li <c:if test="${requestScope.requested_uri == '/credits'}"> class="active"</c:if>><a href="credits"><i class="icon-star icon-white"></i> Credits</a></li>
					<li <c:if test="${requestScope.requested_uri == '/links'}"> class="active"</c:if>><a href="links"><i class="icon-list-alt icon-white"></i> Links</a></li>
				</ul>
			</div>
		</div>
	</div>
	<div class="container-fluid">
		<div class="row-fluid">
			<div class="span2">&nbsp;</div>
			<div class="span6">
				<jsp:include page="/include" />
			</div>
			<div class="span4">
				<div>
					<p><img src="img/learning_vaadin_cover.png" /></p>
					Get Learning Vaadin from <a href="http://www.packtpub.com/learning-vaadin-rias/book" target="_blank" class="btn btn-info btn-mini">Packt</a> or <a href="http://www.amazon.com/Learning-Vaadin-Nicolas-Frankel/dp/1849515220" target="_blank" class="btn btn-info btn-mini">Amazon</a> now!
				</div>
				<div>
					<h1>Recent articles</h1>
					<dl>
						<dt>Integrating Vaadin into legacy applications</dt>
						<dd>Submitted on 04/26/2012 - 22:47</dd>
					</dl>
				</div>
			</div>
		</div>
	</div>
	<script type="text/javascript" src="js/jquery-1.7.2.min.js"></script>
	<script type="text/javascript" src="js/bootstrap.min.js"></script>
	<script type="text/javascript">
    	$('.carousel').carousel();
	</script>
</body>
</html>