package ch.frankel.blog.spring.propertyeditor;

import static java.util.Calendar.MONTH;
import static java.util.Locale.FRANCE;
import static org.testng.Assert.assertEquals;

import java.util.Date;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@ContextConfiguration(locations = "classpath:editors.xml")
public class ConfiguredPropertyEditorTest extends AbstractTestNGSpringContextTests {

	private Dummy dummy;

	@BeforeClass
	protected void setUpBeforeClass() {

		dummy = (Dummy) applicationContext.getBean("dummy");
	}

	@Test
	public void shouldReturnRightLocale() {

		assertEquals(dummy.getLocale(), FRANCE);
	}

	@Test
	public void shouldReturnTrimmedString() {

		assertEquals(dummy.getString(), "");
	}

	@Test
	public void shouldReturnDate() {

		Dummy dummy2 = (Dummy) applicationContext.getBean("dummy2");
		
		Assert.assertTrue(DateUtils.truncatedEquals(dummy2.getDate(), new Date(0), MONTH));
	}
}
