package ch.frankel.blog.spring.propertyeditor;

import static java.util.Locale.FRANCE;
import static org.testng.Assert.assertEquals;

import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@ContextConfiguration(locations = "classpath:beans.xml")
public class DefaultPropertyEditorTest extends AbstractTestNGSpringContextTests {

	private Dummy dummy;

	@BeforeClass
	protected void setUpBeforeClass() {

		dummy = (Dummy) applicationContext.getBean("dummy");
	}

	@Test
	public void shouldReturnRightLocale() {

		assertEquals(dummy.getLocale(), FRANCE);
	}

	@Test
	public void shouldReturnUntrimmedString() {

		assertEquals(dummy.getString(), "   ");
	}
}
