package ch.frankel.blog.powermock.legacy;

import static org.powermock.api.mockito.PowerMockito.mockStatic;
import static org.powermock.reflect.Whitebox.getInternalState;
import static org.testng.Assert.assertEquals;

import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockObjectFactory;
import org.testng.IObjectFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Test;

@PrepareForTest(ExampleUtils.class)
public class CallingCodeTest {

	private CallingCode callingCode;

	@BeforeMethod
	protected void setUp() {

		mockStatic(ExampleUtils.class);

		callingCode = new CallingCode();
	}

	@ObjectFactory
	public IObjectFactory getObjectFactory() {

		return new PowerMockObjectFactory();
	}

	@Test
	public void callingMethodShouldntRaiseException() {

		callingCode.codeThatShouldBeTestedInIsolation();

		assertEquals(getInternalState(callingCode, "i"), 1);
	}
}
