package ch.frankel.blog.vaadin.scala

import com.vaadin.event.EventRouter
import com.vaadin.ui.{Button, CustomComponent, HorizontalLayout, TextField}


@SerialVersionUID(1L)
class CompositeFieldButton extends CustomComponent {

	val field = new TextField(null, "world!")
	
	val layout = new HorizontalLayout()

	val eventRouter = new EventRouter()
	
	eventRouter.addListener(classOf[VisibleClickEvent], this, "displayMessage")
	
	setCompositionRoot(layout)
	
	layout.addComponent(field)
	
	val button = new Button("Hello")
	
	button.addListener(new DisplayMessageClickListener(eventRouter))
	
	layout.addComponent(button)
	
	def displayMessage(event:VisibleClickEvent) = {
		
		getWindow().showNotification(button.getCaption() + " " + field.getValue().asInstanceOf[String])
	}
}