package ch.frankel.blog.metrics.dice;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import static org.springframework.http.MediaType.APPLICATION_JSON_VALUE;

@RestController
public class DiceController {

    private final DiceService diceService;

    public DiceController(DiceService diceService) {
        this.diceService = diceService;
    }

    @RequestMapping("/roll")
    public String roll(HttpServletResponse response) {
        response.setContentType(APPLICATION_JSON_VALUE);
        int roll = diceService.roll();
        return "{ roll : " + roll + " }";
    }
}
