package ch.frankel.blog.metrics;

import org.hamcrest.core.StringStartsWith;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.web.context.WebApplicationContext;
import org.testng.annotations.Test;

import static org.springframework.http.MediaType.APPLICATION_JSON;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.setup.MockMvcBuilders.webAppContextSetup;

@SpringApplicationConfiguration(classes = {WebConfiguration.class, MetricsApplication.class})
@WebAppConfiguration
public class RollIT extends AbstractTestNGSpringContextTests {

    @Test
    public void should_return_roll() throws Exception {
        MockHttpServletRequestBuilder rest = get("/roll");
        MockMvc mockMvc = webAppContextSetup((WebApplicationContext) applicationContext).build();
        mockMvc.perform(rest)
                .andExpect(status().isOk())
                .andExpect(content().contentType(APPLICATION_JSON))
                .andExpect(content().string(new StringStartsWith("{ roll : ")));
    }
}
