package ch.frankel.blog.metrics;

import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.web.context.WebApplicationContext;
import org.testng.annotations.Test;

import static org.springframework.http.MediaType.APPLICATION_JSON;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.setup.MockMvcBuilders.webAppContextSetup;

@SpringApplicationConfiguration(classes = {WebConfiguration.class, MetricsApplication.class})
@WebAppConfiguration
public class PingIT extends AbstractTestNGSpringContextTests {

    @Test
    public void should_return_path_variable() throws Exception {
        MockHttpServletRequestBuilder rest = get("/ping/{id}", 12345);
        MockMvc mockMvc = webAppContextSetup((WebApplicationContext) applicationContext).build();
        mockMvc.perform(rest)
                .andExpect(status().isOk())
                .andExpect(content().contentType(APPLICATION_JSON))
                .andExpect(content().string("{ key : 12345 }"));
    }
}
