package ch.frankel.blog.metrics;

import ch.frankel.blog.metrics.dice.DiceController;
import ch.frankel.blog.metrics.dice.DiceService;
import ch.frankel.blog.metrics.dice.SecureDiceService;
import ch.frankel.blog.metrics.ping.PingController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.security.SecureRandom;

@Configuration
public class WebConfiguration {

    @Bean
    public PingController simpleController() {
        return new PingController();
    }

    @Bean
    public DiceService diceService() {
        return new SecureDiceService(new SecureRandom());
    }

    @Bean
    public DiceController diceController() {
        return new DiceController(diceService());
    }
}
