package ch.frankel.blog.springjbpm;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotNull;

import org.jbpm.api.ExecutionService;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.testng.annotations.Test;

@TransactionConfiguration(defaultRollback = false)
@ContextConfiguration("classpath:spring-jbpm-test.xml")
public class SpringJbpmIT extends AbstractTestNGSpringContextTests {

	@Autowired
	private RepositoryService jbpmRepositoryService;

	@Autowired
	private ExecutionService jbpmExecutionService;

	private ProcessInstance instance;

	@Test
	public void engineShouldDeployJpdl() {

		NewDeployment deployment = jbpmRepositoryService.createDeployment();

		deployment = deployment.addResourceFromClasspath("example.jpdl.xml");

		deployment.deploy();
	}

	@Test(dependsOnMethods = "engineShouldDeployJpdl")
	public void engineShouldStartProcessInstance() {

		instance = jbpmExecutionService.startProcessInstanceByKey("EXA");

		assertNotNull(instance);
	}

	@Test(dependsOnMethods = "engineShouldStartProcessInstance")
	public void engineShouldFindProcessInstance() {

		ProcessInstance sameInstance = jbpmExecutionService.findProcessInstanceById(instance.getId());

		assertEquals(instance.getId(), sameInstance.getId());
	}
	
	@Test(dependsOnMethods = "engineShouldFindProcessInstance")
	public void engineShouldStopProcessInstance() {
		
		jbpmExecutionService.endProcessInstance(instance.getId(), "ended");
		
		assertEquals(jbpmExecutionService.createProcessInstanceQuery().count(), 0);
	}
}
