package ch.frankel.blog.jna.getter;

import java.util.Arrays;

import ch.frankel.blog.jna.Kernel32;

import com.sun.jna.ptr.IntByReference;

/**
 * Class that gets the product version using JNA.
 * 
 * @author Nicolas Frnkel
 * @since 23 mai 2009
 */
public class GetSystemDirectory extends AbstractGetter<String, Kernel32> {

    /**
     * Constructor.
     * 
     * @param library
     */
    public GetSystemDirectory(Kernel32 library) {

        super(library);
    }

    /**
     * @see ch.frankel.blog.jna.getter.AbstractGetter#getValue()
     */
    @Override
    public String getValue() {

        int size = 50;

        char[] buffer = new char[size];

        IntByReference number = new IntByReference(size);

        getLibrary().GetSystemDirectoryW(buffer, number);

        char[] realStr = Arrays.copyOf(buffer, number.getValue());

        return String.valueOf(realStr);
    }
}
