package ch.frankel.blog.jna.getter;

import ch.frankel.blog.jna.Kernel32;

import com.sun.jna.ptr.LongByReference;

/**
 * Class that gets physical RAM using JNA.
 * 
 * @author Nicolas Frnkel
 * @since 23 mai 2009
 */
public class GetPhysicallyInstalledSystemMemory extends AbstractGetter<Long, Kernel32> {

    /**
     * Constructor.
     * 
     * @param library
     */
    public GetPhysicallyInstalledSystemMemory(Kernel32 library) {

        super(library);
    }

    /**
     * @see ch.frankel.blog.jna.getter.AbstractGetter#getValue()
     */
    @Override
    public Long getValue() {

        LongByReference ref = new LongByReference();

        getLibrary().GetPhysicallyInstalledSystemMemory(ref);

        return ref.getValue();
    }
}
