package ch.frankel.blog.jna.getter;

import java.util.Arrays;

import ch.frankel.blog.jna.Kernel32;

import com.sun.jna.ptr.IntByReference;

/**
 * Class that gets the computer name using JNA.
 * 
 * @author Nicolas Frnkel
 * @since 23 mai 2009
 */
public class GetComputerName extends AbstractGetter<String, Kernel32> {

    /**
     * Constructor.
     * 
     * @param library
     */
    public GetComputerName(Kernel32 library) {

        super(library);
    }

    /**
     * @see ch.frankel.blog.jna.getter.AbstractGetter#getValue()
     */
    @Override
    public String getValue() {

        int size = 30;

        char[] buffer = new char[size];

        IntByReference number = new IntByReference(size);

        getLibrary().GetComputerNameW(buffer, number);

        char[] realStr = Arrays.copyOf(buffer, number.getValue());

        return String.valueOf(realStr);
    }
}
