package ch.frankel.blog.jna.getter;

import com.sun.jna.Library;

/**
 * Abstraction over a getter.
 * 
 * @author Nicolas Frnkel
 * @param <V>
 *            Type of get object
 * @param <L>
 *            Library type
 * @since 23 mai 2009
 */
public abstract class AbstractGetter<V, L extends Library> implements Getter<V> {

    /** Library used. */
    private final L library;

    /**
     * Constructor.
     * 
     * @param library
     */
    public AbstractGetter(L library) {

        this.library = library;
    }

    /**
     * @see ch.frankel.blog.jna.getter.Getter#getValue()
     */
    public abstract V getValue();

    /**
     * Return the libraru to use.
     * 
     * @return Library
     */
    protected L getLibrary() {

        return library;
    }
}
