package ch.frankel.blog.jna;

import java.text.NumberFormat;

import ch.frankel.blog.jna.getter.GetComputerName;
import ch.frankel.blog.jna.getter.GetPhysicallyInstalledSystemMemory;
import ch.frankel.blog.jna.getter.GetSystemDirectory;

import com.sun.jna.Native;

/**
 * Bootstrap class.
 * 
 * @author Nicolas Frnkel
 * @since 23 mai 2009
 */
public class Main {

    /**
     * Entry point method.
     * 
     * @param args
     */
    public static void main(String[] args) {

        Kernel32 kernel32 = (Kernel32) Native.loadLibrary("kernel32", Kernel32.class);

        System.out.println("Computer name   : " + new GetComputerName(kernel32).getValue());
        System.out.println("System directory: " + new GetSystemDirectory(kernel32).getValue());
        System.out.println("RAM (in Gb)     : "
                + NumberFormat.getNumberInstance().format(
                        ((Long) new GetPhysicallyInstalledSystemMemory(kernel32).getValue()) / (1024 * 1024)));
    }
}
