package ch.frankel.blog.jna;

import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.win32.StdCallLibrary;

/**
 * Interface over kernel32.dll.
 * 
 * @author Nicolas Frnkel
 * @since 23 mai 2009
 */
public interface Kernel32 extends StdCallLibrary {

    /**
     * Maps <code>GetComputerNameW</code>.
     * 
     * @param name
     * @param number
     * @return 0 if no error
     */
    public int GetComputerNameW(char[] name, IntByReference number);

    /**
     * Maps <code>GetSystemDirectoryW</code>.
     * 
     * @param name
     * @param number
     * @return 0 if no error
     */
    public int GetSystemDirectoryW(char[] name, IntByReference number);

    /**
     * Maps <code>GetPhysicallyInstalledSystemMemory</code>.
     * 
     * @param number
     * @return
     */
    public boolean GetPhysicallyInstalledSystemMemory(LongByReference number);
}
