package ch.frankel.blog.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jmx.export.MBeanExporter;

/**
 * Application entry point.
 * 
 * @author Nicolas Frnkel
 * @since 28 mai 2009
 */
public class Main {

    /**
     * Bootstrap method.
     * 
     * @param args
     * @throws Exception
     */
    public static void main(String... args) throws Exception {

        ApplicationContext context = new ClassPathXmlApplicationContext("config/spring/beans.xml");

        MBeanServer server = ((MBeanExporter) context.getBean("exporter")).getServer();

        SimpleConfiguration cfg = new SimpleConfiguration();

        server.registerMBean(cfg, new ObjectName("bean:type=configuration,name=simple"));

        // Keeps the application from terminating until any key is pressed in
        // the console
        System.in.read();
    }
}
