package ch.frankel.blog.twitter4j;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.RequestToken;

public class AuthenticationUrlFilter implements Filter {

	/**
	 * This implementation does nothing.
	 */
	public void init(FilterConfig filterConfig) throws ServletException {}

	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {

		// Creates the main object
		Twitter twitter = new TwitterFactory().getInstance();

		try {

			// Ask for a request token
			RequestToken requestToken = twitter.getOAuthRequestToken();

			// Store the token in session
			((HttpServletRequest) request).getSession().setAttribute("rt", requestToken);

			// Extract the authentication URL
			String authUrl = requestToken.getAuthenticationURL();

			// Send the Twitter authentication page to the page to create a popup from there
			request.setAttribute("auth", authUrl);
		
			chain.doFilter(request, response);
			
		} catch (TwitterException e) {

			throw new ServletException(e);
		}
	}

	/**
	 * This implementation does nothing.
	 */
	public void destroy() {}
}
