package ch.frankel.blog.twitter4j;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public class AuthenticateServlet extends HttpServlet {

	/** Class serial version unique identifier. */
	private static final long serialVersionUID = 1L;

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		// Creates the main object
		Twitter twitter = new TwitterFactory().getInstance();

		// Read the PIN
		String pin = request.getParameter("pin");

		AccessToken accessToken = (AccessToken) request.getSession().getAttribute("at");
		
		try {
			
			if (accessToken == null) {

				// Retrieve the request token
				RequestToken requestToken = (RequestToken) request.getSession().getAttribute("rt");
	
				// Ask for an access token
				accessToken = twitter.getOAuthAccessToken(requestToken, pin);
	
				// Store the token in session
				request.getSession().setAttribute("at", accessToken);
	
				// Remove the access token from session
				request.getSession().removeAttribute("rt");
			}

			// Set the access token on the twitter instance
			twitter.setOAuthAccessToken(accessToken);

			// Now, we can ask for whatever we want!
			ResponseList<Status> statuses = twitter.getUserTimeline();
			
			request.setAttribute("statuses", statuses);
			
			request.getRequestDispatcher("/WEB-INF/timeline.jsp").forward(request, response);

		} catch (TwitterException e) {

			throw new ServletException(e);
		}
	}
}
