package ch.frankel.blog.pit;

import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;

public class DiscountEngineTest {

    private DiscountEngine discounter;

    @BeforeMethod
    protected void setUp() {

        discounter = new DiscountEngine();
    }

    @Test(expectedExceptions = IllegalArgumentException.class)
    public void should_throw_exception_when_price_negative() {

        discounter.apply(new Double(0.9), new Double(-1.0));
    }

    @Test(expectedExceptions = IllegalArgumentException.class)
    public void should_throw_exception_when_discount_higher_than_1() {

        discounter.apply(new Double(1.1), new Double(10.0));
    }

    @Test
    public void should_apply_discount() {

        Double price = discounter.apply(new Double(0.5), new Double(10));

        assertEquals(price, new Double(5));
    }
}
