package ch.frankel.blog.pit;

public class DiscountEngine {

    public Double apply(Double discount, Double price) {

        if (discount.doubleValue() > 1) {

            throw new IllegalArgumentException("Discount cannot be higher than 1.00");
        }

        if (price.doubleValue() < 0) {

            throw new IllegalArgumentException("Price cannot be negative");
        }

        return (1 - discount.doubleValue()) * price.doubleValue();
    }
}
