package ch.frankel.blog.spring.javaconfig;

import ch.frankel.blog.spring.javaconfig.legacy.BarService;
import ch.frankel.blog.spring.javaconfig.legacy.Dummy;
import ch.frankel.blog.spring.javaconfig.legacy.FooService;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import static ch.frankel.blog.spring.javaconfig.legacy.Dummy.ONE;
import static org.testng.Assert.assertEquals;

@ContextConfiguration("classpath:spring-config.xml")
public class InitialTest extends AbstractTestNGSpringContextTests {

    private FooService foo;
    private BarService bar;

    @BeforeMethod
    protected void setUp() {

        foo = applicationContext.getBean(FooService.class);
        bar = applicationContext.getBean(BarService.class);
    }

    @Test
    public void testFooInitialSetup() {

        Dummy dummy = foo.get(0);

        assertEquals(dummy, ONE);
    }

    @Test
    public void testBarInitialSetup() {

        Dummy dummy = bar.get(0);

        assertEquals(dummy, ONE);
    }
}
