package ch.frankel.blog.spring.javaconfig;

import ch.frankel.blog.spring.javaconfig.legacy.BarService;
import ch.frankel.blog.spring.javaconfig.legacy.Dummy;
import ch.frankel.blog.spring.javaconfig.legacy.FooService;
import ch.frankel.blog.spring.javaconfig.shiny.MyFacade;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import static ch.frankel.blog.spring.javaconfig.legacy.Dummy.ONE;
import static ch.frankel.blog.spring.javaconfig.legacy.Dummy.THREE;
import static ch.frankel.blog.spring.javaconfig.legacy.Dummy.TWO;
import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertSame;

@ContextConfiguration("classpath:shiny-spring-config.xml")
public class FinalTest extends AbstractTestNGSpringContextTests {

    private MyFacade myFacade;

    @BeforeMethod
    protected void setUp() {

        myFacade = applicationContext.getBean(MyFacade.class);
    }

    @Test
    public void testFacadeFinalSetup() {

        Dummy[] dummies = myFacade.searchForDummies(0, 1, 2);

        assertEquals(dummies.length, 3);

        assertSame(dummies[0], ONE);
        assertSame(dummies[1], TWO);
        assertSame(dummies[2], THREE);
    }
}
