package ch.frankel.blog.spring.javaconfig.shiny;

import ch.frankel.blog.spring.javaconfig.legacy.BarService;
import ch.frankel.blog.spring.javaconfig.legacy.Dummy;
import ch.frankel.blog.spring.javaconfig.legacy.FooService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MyFacade {

    private FooService foo;
    private BarService bar;
    private AnotherService anotherService;

    public MyFacade(FooService foo, BarService bar, AnotherService anotherService) {

        this.anotherService = anotherService;
        this.bar = bar;
        this.foo = foo;
    }

    public Dummy[] searchForDummies(int... id) {

        List<Dummy> dummies = new ArrayList<Dummy>();

        switch (id.length) {

            case 3:
                dummies.add(anotherService.get(id[2]));
            case 2:
                dummies.add(bar.get(id[1]));
            case 1:
                dummies.add(bar.get(id[0]));
        }

        Collections.reverse(dummies);

        return dummies.toArray(new Dummy[dummies.size()]);
    }
}
