package ch.frankel.blog.spring.javaconfig.config;

import ch.frankel.blog.spring.javaconfig.legacy.BarService;
import ch.frankel.blog.spring.javaconfig.legacy.FooDao;
import ch.frankel.blog.spring.javaconfig.legacy.FooService;
import ch.frankel.blog.spring.javaconfig.shiny.AnotherService;
import ch.frankel.blog.spring.javaconfig.shiny.MyFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JavaConfig {

    @Autowired
    private FooDao fooDao;

    @Autowired
    private FooService fooService;

    @Autowired
    private BarService barService;

    @Bean
    public AnotherService anotherService() {

        return new AnotherService(fooDao);
    }

    @Bean
    public MyFacade myFacade() {

        return new MyFacade(fooService, barService, anotherService());
    }
}
