package ch.frankel.blog.envers.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import ch.frankel.blog.envers.entity.Person;

public class PersonDaoImpl extends HibernateDaoSupport implements PersonDao {

	public Person get(Long id) {

		return getHibernateTemplate().get(Person.class, id);
	}

	public void persist(Person person) {

		getHibernateTemplate().persist(person);
	}

	public void update(Person person) {

		getHibernateTemplate().saveOrUpdate(person);
	}

	public List<Person> getPersonHistory(final Long id) {
		
		return getHibernateTemplate().execute(new HibernateCallback<List<Person>>() {

			public List<Person> doInHibernate(Session session) throws HibernateException, SQLException {

				AuditReader reader = AuditReaderFactory.get(session);
				
				List<Number> revisions = reader.getRevisions(Person.class, id);
				
				List<Person> persons = new ArrayList<Person>(revisions.size());
				
				for (Number number : revisions) {
					
					persons.add(reader.find(Person.class, id, number));
				}
				
				return persons;
			}
		});
	}
}
