package ch.frankel.blog.envers.dao;

import static org.springframework.transaction.TransactionDefinition.PROPAGATION_REQUIRES_NEW;
import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertFalse;
import static org.testng.Assert.assertNotNull;
import static org.testng.Assert.assertTrue;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTransactionalTestNGSpringContextTests;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import ch.frankel.blog.envers.entity.Person;

@ContextConfiguration("classpath:spring-persistence.xml")
@TransactionConfiguration(defaultRollback = false)
public class PersonDaoImplTest extends AbstractTransactionalTestNGSpringContextTests {

	@Autowired
	private PersonDao personDao;

	@SuppressWarnings("deprecation")
	@BeforeMethod
	protected void setUp() {

		simpleJdbcTemplate.update("TRUNCATE TABLE PERSON_AUD");
		simpleJdbcTemplate.update("TRUNCATE TABLE PERSON");
		simpleJdbcTemplate.update("DELETE FROM REVINFO");
		simpleJdbcTemplate.update("INSERT INTO PERSON (ID, FIRSTNAME, LASTNAME) VALUES(1, 'John', 'Doe')");
	}

	@Test
	public void personShouldBeAuditedWhenUpdatedWithManualTransaction() {

		PlatformTransactionManager txMgr = applicationContext.getBean(PlatformTransactionManager.class);

		TransactionStatus status = txMgr.getTransaction(new DefaultTransactionDefinition(PROPAGATION_REQUIRES_NEW));

		Person person = personDao.get(1L);

		person.setFirstName("Jane");

		txMgr.commit(status);

		List<Person> history = personDao.getPersonHistory(1L);

		assertNotNull(history);
		assertFalse(history.isEmpty());
		assertEquals(history.size(), 1);
	}

	@Test
	public void personIsNotAuditedWhenUpdatedWithoutManualTransaction() {

		Person person = personDao.get(1L);

		person.setFirstName("Jane");

		List<Person> history = personDao.getPersonHistory(1L);

		assertNotNull(history);
		assertTrue(history.isEmpty());
	}
}
