package ch.frankel.blog.envers.event;

import java.util.Date;

import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;

import ch.frankel.blog.envers.entity.Person;

@SuppressWarnings("serial")
public class TimestampListener implements PreUpdateEventListener, PreInsertEventListener {

	public boolean onPreInsert(PreInsertEvent event) {

		Object entity = event.getEntity();

		if (Person.class.isAssignableFrom(entity.getClass())) {
			
			Person person = (Person) entity;
			
			person.setCreated(new Date());
		}
		
		return false;
	}

	public boolean onPreUpdate(PreUpdateEvent event) {

		Object entity = event.getEntity();

		if (Person.class.isAssignableFrom(entity.getClass())) {
			
			Person person = (Person) entity;
			
			person.setLastUpdated(new Date());
		}
		
		return false;
	}
}
