package ch.frankel.blog.envers.entity;

import static javax.persistence.TemporalType.DATE;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Temporal;

import org.hibernate.envers.Audited;

@Entity
@Audited
public class Person {

	@Id
	private Long id;

	private String firstName;

	private String lastName;

	@Temporal(DATE)
	private Date birthdate;

	private Date lastUpdated;

	private Date created;

	public Date getBirthdate() {

		return birthdate;
	}

	public Date getCreated() {
	
		return (Date) created.clone();
	}

	public String getFirstName() {

		return firstName;
	}

	public Long getId() {

		return id;
	}

	public String getLastName() {

		return lastName;
	}

	public Date getLastUpdated() {
	
		return (Date) lastUpdated.clone();
	}

	public void setBirthdate(Date birthdate) {

		this.birthdate = birthdate;
	}

	public void setCreated(Date created) {
	
		this.created = created;
	}

	public void setFirstName(String firstName) {

		this.firstName = firstName;
	}

	public void setId(Long id) {

		this.id = id;
	}

	public void setLastName(String lastName) {

		this.lastName = lastName;
	}

	public void setLastUpdated(Date lastUpdated) {
	
		this.lastUpdated = lastUpdated;
	}
}
